#include <mail/sendbernar/server/include/handlers/compose_draft.h>
#include <mail/sendbernar/server/include/fwd.h>
#include <mail/sendbernar/composer/include/mail_compose.h>
#include <mail/sendbernar/core/include/cached_compose_result.h>
#include <mail/sendbernar/services/include/make_responses.h>
#include <mail/sendbernar/services/include/source_mid.h>
#include <mail/sendbernar/server/include/compose.h>


namespace sendbernar::server::handlers {

void ComposeDraft::doSendbernar(Context& ctx, const Account& a,
                                params::CommonParams common, MetadataPtr m) const {

    const auto p = getComposeDraft(ctx);
    const auto cfg = sendConfig();
    SourceMid sourceMid(p.message, m, ctx.logger);
    compose::Expected<compose::ComposeDraft> composed = mailCompose(cfg, ctx, a, m, sourceMid, common, p);


    if (!composed) {
        ctx.responseWith(make_error(composed.error().result), composed.error().messageId);
    } else {
        ctx.responseWith(makeComposeDraftResult(composed.value(), cfg->mimeTypesList()));
    }
}

}

SBR_HANDLER_IMPL(sendbernar::server::handlers, ComposeDraft)
