#include <mail/sendbernar/server/include/handlers/compose_message.h>
#include <mail/sendbernar/server/include/fwd.h>
#include <mail/sendbernar/composer/include/mail_compose.h>
#include <mail/sendbernar/core/include/cached_compose_result.h>
#include <mail/sendbernar/services/include/source_mid.h>
#include <mail/sendbernar/server/include/compose.h>


namespace sendbernar::server::handlers {

void ComposeMessage::doSendbernar(Context& ctx, const Account& a,
                                  params::CommonParams common, MetadataPtr m) const {

    const auto p = getComposeMessage(ctx);
    const auto cfg = sendConfig();
    SourceMid sourceMid(p.message, m, ctx.logger);
    compose::Expected<compose::ComposeMessage> composed = mailCompose(cfg, ctx, a, m, sourceMid, common, p);


    if (!composed) {
        ctx.responseWith(make_error(composed.error().result), composed.error().messageId);
    } else {
        compose::ComposeMessage& msg = composed.value();
        ComposeMessageResult result;
        result.text = std::move(*msg.text);

        const auto adaptor = boost::adaptors::transformed([](const auto& email) {
            return email.addressString();
        });

        boost::copy(msg.recipients.to()  | adaptor, std::back_inserter(result.to));
        boost::copy(msg.recipients.cc()  | adaptor, std::back_inserter(result.cc));
        boost::copy(msg.recipients.bcc() | adaptor, std::back_inserter(result.bcc));
        result.from = std::move(msg.envelopeFrom);

        ctx.responseWith(result);
    }
}

}

SBR_HANDLER_IMPL(sendbernar::server::handlers, ComposeMessage)
