#include <mail/sendbernar/server/include/handlers/generate_operation_id.h>
#include <mail/sendbernar/server/include/fwd.h>
#include <util/generic/guid.h>


namespace sendbernar::server::handlers {

void GenerateOperationId::doSendbernar(Context& ctx, const Account&,
                                       params::CommonParams, MetadataPtr) const {
    ctx.responseWith(GenerateOperationIdResponse {
        .id=fmt::format("{datetime}_{uuid}",
            fmt::arg("datetime", std::time(nullptr)),
            fmt::arg("uuid", CreateGuidAsString())
        )
    });
}

}

SBR_HANDLER_IMPL(sendbernar::server::handlers, GenerateOperationId)
