#include <mail/sendbernar/server/include/handlers/limits.h>
#include <mail/sendbernar/server/include/fwd.h>


namespace sendbernar::server::handlers {

void Limits::execute(Context& ctx) const {
    const auto resp = limits(getLimitsParams(ctx), config_->send->smtplimits(),
                             config_->send->maxRecipients(), config_->send->attachmentsMaxSize(),
                             config_->send->messageMaxSize(), config_->send->limitsFactor());

    if (resp) {
        ctx.responseWith(resp.value());
    } else {
        ctx.responseWith(resp.error());
    }
}

}

SBR_HANDLER_IMPL(sendbernar::server::handlers, Limits)
