#include <mail/sendbernar/server/include/handlers/list_unsubscribe.h>
#include <mail/sendbernar/server/include/fwd.h>
#include <mail/sendbernar/composer/include/system_mail_composer.h>
#include <mail/sendbernar/services/include/smtp_gate.h>
#include <mail/sendbernar/composer/include/delivery_helpers.h>


namespace sendbernar::server::handlers {

void ListUnsubscribe::doSendbernar(Context& ctx, const Account& account,
                                   params::CommonParams common, MetadataPtr) const {
    const auto params = getListUnsubscribe(ctx);

    SystemMailComposer composer;
    if (params.subject) {
        composer.subject(*params.subject);
    }

    if (params.body) {
        composer.body(*params.body);
    }

    if (params.from_mailbox) {
        composer.fromMailbox(*params.from_mailbox);
    } else {
        composer.fromMailbox(account.defaultAddress);
    }

    auto composed = composer.desiredCharset("utf-8")
            .messageMaxSize(sendConfig()->messageMaxSize())
            .to(params.to)
            .subtype("plain")
            .compose();

    if (!composed) {
        ctx.responseWith(make_error(composed.error()));
        return;
    }

    NwSmtp nw(common, ctx.metrics, ctx.http, sendConfig()->nwsmtp());
    DeliveryResult nwResult = nw.sendSystemMessage({ }, { }, { }, composer.recipients(), std::move(composed.value())).deliveryResult;

    if (nwResult != DeliveryResult::ok) {
        ctx.responseWith(make_error(nwResult));
    } else {
        ctx.responseWith(ListUnsubscribeResponse{composer.messageId()});
    }
}

}

SBR_HANDLER_IMPL(sendbernar::server::handlers, ListUnsubscribe)
