#include <mail/sendbernar/server/include/handlers/save_draft.h>
#include <mail/sendbernar/server/include/fwd.h>
#include <mail/sendbernar/services/include/smtp_gate.h>
#include <mail/sendbernar/composer/include/mail_compose.h>
#include <mail/sendbernar/services/include/delayed.h>
#include <mail/sendbernar/core/include/sharpei.h>
#include <mail/sendbernar/services/include/make_responses.h>
#include <mail/sendbernar/server/include/compose.h>


namespace sendbernar::server::handlers {

void SaveDraft::doSendbernar(Context& ctx, const Account& a,
                             params::CommonParams common, MetadataPtr m) const {

    const auto p = getSaveDraft(ctx);
    const auto cfg = sendConfig();
    const auto& http = ctx.http;

    if (!isMasterAlive(common.uid, cfg->sharpei(), http)) {
        ctx.responseWith(make_error(ErrorResult::cannotSaveMessage, "cannot save message, master is dead"));
        return;
    }

    SourceMid sourceMid(p.message, m, ctx.logger);
    deleteDelayedReminder(common.uid, sourceMid, http, cfg);

    compose::Expected<compose::SaveDraftOrTemplate> composed = mailCompose(cfg, ctx, a, m, sourceMid, common, p);

    if (!composed) {
        ctx.responseWith(make_error(composed.error().result), composed.error().messageId);
        return;
    }

    compose::SaveDraftOrTemplate& msg = composed.value();
    MessageSavedResponse resp = makeSaveResponse(msg, m->fidBySymbol(macs::Folder::Symbol::drafts),
                                                 cfg->mimeTypesList());
    DeliveryResult result;

    std::tie(result, resp.stored.mid) = NwSmtp(common, ctx.metrics, http, cfg->nwsmtp())
            .save({ macs::Label::Symbol::seen_label,
                    macs::Label::Symbol::draft_label },
                  filteredLids(p, m), resp.stored.fid, sourceMid.optional(), std::move(msg));


    if (result == DeliveryResult::ok) {
        ctx.responseWith(std::move(resp));
    } else {
        ctx.responseWith(make_error(result));
    }
}

}

SBR_HANDLER_IMPL(sendbernar::server::handlers, SaveDraft)
