#include <mail/sendbernar/server/include/handlers/send_barbet_message.h>
#include <mail/sendbernar/server/include/remind_message_sender.h>
#include <mail/sendbernar/server/include/fwd.h>
#include <mail/sendbernar/core/include/composed_message.h>


namespace sendbernar::server::handlers {

void SendBarbetMessage::doSendbernar(Context& ctx, const Account& account,
                                     params::CommonParams common, MetadataPtr) const {
    const auto p = getSendBarbetMessage(ctx);

    RemindTemplates templates;
    switch (p.type) {
        case params::BarbetMessageType::create_failed:
            templates = sendConfig()->reminders().barbetCreateFailedTemplates;  break;
        case params::BarbetMessageType::restore_failed:
            templates = sendConfig()->reminders().barbetRestoreFailedTemplates; break;
    }

    mail_errors::error_code e = RemindMessageSender(common, templates, ctx, sendConfig())
            .to(account.defaultAddress)
            .lang(account.language)
            .composeAndSend(p.uniq_id);

    if (e) {
        ctx.responseWith(e);
    } else {
        ctx.responseWith(SendBarbetMessageResponse());
    }
}

}

SBR_HANDLER_IMPL(sendbernar::server::handlers, SendBarbetMessage)
