#include <mail/sendbernar/server/include/handlers/send_share.h>
#include <mail/sendbernar/server/include/fwd.h>
#include <mail/sendbernar/services/include/smtp_gate.h>
#include <mail/sendbernar/composer/include/mail_compose.h>
#include <mail/sendbernar/composer/include/delivery_helpers.h>
#include <mail/sendbernar/services/include/delayed.h>
#include <mail/sendbernar/services/include/captcha.h>
#include <mail/sendbernar/core/include/sharpei.h>
#include <mail/sendbernar/services/include/postprocess.h>
#include <mail/sendbernar/services/include/make_responses.h>
#include <mail/sendbernar/services/include/operation_id.h>
#include <mail/sendbernar/server/include/compose.h>


namespace sendbernar::server::handlers {

void SendShare::doSendbernar(Context& ctx, const Account& a,
                             params::CommonParams common, MetadataPtr m) const {

    const auto p = getSendShare(ctx);
    auto cfg = sendConfig();
    const auto& http = ctx.http;


    SourceMid sourceMid(p.message, m, ctx.logger);

    params::CommonParams forAdmin = common;
    forAdmin.uid = p.admin_uid;
    Account admin = BlackBox(sendConfig()->blackBox(), http, authDomain(forAdmin)).getAccount(forAdmin);

    compose::Expected<compose::SendMessage> composed = mailCompose(cfg, ctx, a, m, sourceMid, common, p, admin);

    if (!composed) {
        ctx.responseWith(make_error(composed.error().result), composed.error().messageId);
        return;
    }

    compose::SendShare msg {
        .message = std::move(composed.value()),
        .envelopeFrom = admin.defaultAddress,
        .adminUid = p.admin_uid
    };

    const NwSmtp smtp(common, ctx.metrics, http, cfg->nwsmtp());

    DeliveryResult sendResult = smtp.sendShare(filteredLids(p, m), msg).deliveryResult;

    if (sendResult == DeliveryResult::ok) {
        ctx.responseWith(makeSentResponse(msg.message));
    } else {
        ctx.responseWith(sendbernar::MessageWithErrorOnSharing {
            .result=sendResult
        });
    }
}

}

SBR_HANDLER_IMPL(sendbernar::server::handlers, SendShare)
