#include <mail/sendbernar/server/include/handlers/write_attachment.h>
#include <mail/sendbernar/server/include/fwd.h>
#include <mail/sendbernar/composer/include/attach_helpers.h>
#include <mail_getter/attachment_storage.h>


namespace sendbernar::server::handlers {

void WriteAttachment::execute(Context& ctx) const {
    params::CommonParams common;
    params::WriteAttachParams attach;
    try {
        common = getCommonParams(ctx, ctx.request->context->remote_address);
        attach = getWriteAttachParams(ctx);
    } catch (const ReaderException& e) {
        ctx.responseWith(make_error(ErrorResult::invalidParam, e.what()));
        return;
    }

    LOGDOG_(ctx.logger, debug, log::write_attachment_size=attach.raw_body.size());

    const auto ticket = tvm::Ticket().setUid(common.uid).setTicket(ctx.optionalHeader(tvm::headerName()).get_value_or(""));
    const auto mgLogger = getMulcagateLogger(ctx.logger);
    const auto storageService = config_->send->mailStorage()->createService(mgLogger, ticket,
        common.requestId);
    auto storage = storageService->createAttachmentStorage("");

    MimeType type;
    type.setDefaultMimeType();

    const auto hash = calcHashAttachment(attach.raw_body, attach.filename);

    std::string id;
    mail_getter::AttachmentStorage::MetaInfo meta;
    int errorCode = storage->add(mail_getter::SimpleAttachment(attach.filename,
                                                               type.toString(),
                                                               std::move(attach.raw_body)),
                                 id, meta,
                                 config_->attachConfig->expireTimeout,
                                 config_->attachConfig->shieldTimeout,
                                 config_->send->keys()
                                 );
    if ( errorCode != 0 ) {
        ctx.responseWith(make_error(ErrorResult::storageError, "Can't add attachment to the storage"));
    } else {
        WriteAttachmentResponse resp;
        resp.id = meta.sid;
        resp.hash = std::move(hash);
        ctx.responseWith(resp);
    }
}

}

SBR_HANDLER_IMPL(sendbernar::server::handlers, WriteAttachment)
