#pragma once

#include <ymod_webserver/response.h>
#include <ymod_webserver/codes.h>

#include <mail/sendbernar/client/include/handler_url.h>

#include <mail/sendbernar/core/include/config.h>
#include <mail/sendbernar/server/include/context.h>
#include <mail/sendbernar/core/include/account.h>
#include <yplatform/find.h>

#include <mail/webmail/http_api_helpers/include/merge_args_as_tskv.h>


namespace sendbernar {
namespace server {

struct Base {
    using Logger = yplatform::log::source;

    const ConfigPtr config_;
    const http_api::LogArgsAsTskvConfig logArgsConfig_;

    Base(ConfigPtr configuration);

    virtual ~Base() { }

    void process(const ymod_webserver::http::stream_ptr& stream) const;

    virtual std::vector<std::string> paths() const = 0;
    virtual ymod_webserver::methods::http_method method() const = 0;
    virtual void execute(Context&) const = 0;

    template<class Fn>
    void spawnCoroutine(Fn fn) const {
        auto reactor = yplatform::find_reactor<std::shared_ptr>("global");
        boost::asio::spawn(*reactor->io(), fn, boost::coroutines::attributes(config_->coroutineStackSize));
    }
};

}
}
