#pragma once

#include <mail/sendbernar/composer/include/mail_compose.h>
#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/services/include/source_mid.h>
#include <mail/sendbernar/services/include/captcha.h>
#include <mail/sendbernar/server/include/context.h>
#include <mail/sendbernar/core/include/account.h>
#include <mail/sendbernar/core/include/metadata.h>

#include <yplatform/find.h>


namespace sendbernar::server {

template<class Fn, class Handler>
auto asyncCompose(Fn fn, Handler handler) {
    using Result = decltype(fn());

    io_result::detail::init_async_result<
            Handler,
            io_result::Hook<Result>> init(
        handler
    );

    auto reactor = yplatform::find_reactor<std::shared_ptr>("sendbernar_reactor");

    reactor->io()->post([fn = std::move(fn), h = std::move(init.handler)]() mutable {
        try {
            h(mail_errors::error_code(), fn());
        } catch (const std::exception& e) {
            h(make_error(ErrorResult::unexpectedCondition, e.what()), Result());
        } catch (...) {
            h(make_error(ErrorResult::unexpectedCondition, "unexpected condition"), Result());
        }
    });

    return init.result.get();
}

template<class Params>
auto mailCompose(const SendConfigurationPtr& cfg, Context& ctx,
                 const Account& a, MetadataPtr m, SourceMid& sourceMid,
                 const params::CommonParams& common, const Params& p) {
    auto mailCompose = std::make_shared<MailCompose>(cfg, ctx.logger, ctx.httpPtr, a, m, sourceMid.messageId(), common);
    return mailCompose->compose(p);
}

inline auto mailCompose(const SendConfigurationPtr& cfg, Context& ctx,
                 const Account& a, MetadataPtr m, SourceMid& sourceMid,
                 const params::CommonParams& common, const params::SendShare& p, const Account& additional) {
    auto mailCompose = std::make_shared<MailCompose>(cfg, ctx.logger, ctx.httpPtr, a, m, sourceMid.messageId(), common, additional);
    return mailCompose->compose(p);
}

template<class Params>
auto mailCompose(const SendConfigurationPtr& cfg, Context& ctx,
                 const Account& a, MetadataPtr m, SourceMid& sourceMid,
                 const params::CommonParams& common, const Params& p,
                 CheckCaptchaResult captcha) {
    auto mailCompose = std::make_shared<MailCompose>(cfg, ctx.logger, ctx.httpPtr, a, m, sourceMid.messageId(), common);
    return mailCompose->compose(p, captcha);
}

}
