#pragma once

#include <ymod_webserver/server.h>
#include <ymod_webserver/request.h>

#include <mail/sendbernar/client/include/response.h>
#include <mail/sendbernar/core/include/metrics.h>
#include <mail/sendbernar/core/include/logger.h>

#include <boost/optional.hpp>
#include <mail/sendbernar/core/include/http.h>


namespace sendbernar::server {

boost::optional<std::string> getOptionalHeader(const ymod_webserver::request_ptr& request, const std::string& name);

struct Context: public Request {
    ymod_webserver::request_ptr request;
    RequestMertics metrics;
    ContextLogger logger;
    std::string method;
    ymod_webserver::response_ptr response;
    http_getter::TypedClientPtr httpPtr;
    const http_getter::TypedClient& http;
    bool logResponse;

    Context(const ymod_webserver::http::stream_ptr& stream, bool logResponse, const http_getter::TypedClientModule& typedModule);

    virtual ~Context() = default;

    boost::optional<std::vector<std::string>> optionalArgs(const std::string& name) const override;
    boost::optional<std::string> optionalArg(const std::string& name) const override;
    boost::optional<std::string> optionalHeader(const std::string& name) const override;
    std::string rawBody() const override;
    std::string requestId() const;

    template <typename ... Ts>
    void responseWith(Ts&& ... args) {
        response::Response resp(std::forward<Ts>(args)...);
        if (logResponse) {
            LOGDOG_(logger, notice, log::where_name=method, http_getter::log::body=resp.body);
        }
        responseWith(std::move(resp));
    }

    void responseWith(const std::string & data) {
        responseWith(response::Response(data));
    }

private:
    void responseWith(response::Response resp);
};

}
