#pragma once

#include <mail/sendbernar/server/include/base.h>


namespace sendbernar::server {

template<typename>
std::shared_ptr<Base> createHandler(sendbernar::ConfigPtr cfg);

namespace handlers {
    struct Ping;
    struct Limits;
    struct SaveDraft;
    struct SaveTemplate;
    struct SendMessage;
    struct SendService;
    struct SendDelayed;
    struct SendShare;
    struct SendUndo;
    struct CancelSendDelayed;
    struct ComposeMessage;
    struct ComposeDraft;
    struct WriteAttachment;
    struct ListUnsubscribe;
    struct GenerateOperationId;
    struct SendBarbetMessage;
}

namespace callbacks {
    struct DelayedMessage;
    struct NoAnswerRemindHandler;
}

}

#define SBR_HANDLER_IMPL(name_of_space, type) \
namespace sendbernar::server { \
    template<> \
    std::shared_ptr<Base> createHandler<::name_of_space::type>(sendbernar::ConfigPtr cfg) \
    {return std::make_shared<::name_of_space::type>(std::move(cfg));} \
}

