#pragma once

#include <mail/sendbernar/server/include/send_base.h>

namespace sendbernar {
namespace server {
namespace handlers {

struct CancelSendDelayed: public SendBase {
    CancelSendDelayed(ConfigPtr configuration)
        : SendBase(configuration)
    { }

    std::vector<std::string> paths() const override {
        return { cancelSendDelayedUrl(), cancelSendUndoUrl() };
    }

    ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_post;
    }

    void doSendbernar(Context& context, const Account&, params::CommonParams common,
                      MetadataPtr metadata) const override;

private:
    mail_errors::error_code deleteReminder(const params::Uid& uid, const params::Mid& mid, MetadataPtr metadata,
                                           ContextLogger logger, const http_getter::TypedClient& http) const;
    void remarkEnvelope(const params::Mid& mid, MetadataPtr metadata) const;
    void moveMessage(const params::Mid& mid, MetadataPtr metadata) const;
};

}
}
}
