#pragma once

#include <mail/sendbernar/server/include/send_base.h>


namespace sendbernar {
namespace server {
namespace handlers {

struct ComposeDraft: public SendBase {
    ComposeDraft(ConfigPtr configuration)
        : SendBase(configuration)
    { }

    virtual ~ComposeDraft() { }

    std::vector<std::string> paths() const override {
        return { composeDraftUrl() };
    }

    ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_post;
    }

    void doSendbernar(Context& ctx, const Account& account,
                      params::CommonParams utility, MetadataPtr metadata) const override;
};

}
}
}
