#pragma once

#include <mail/sendbernar/server/include/send_base.h>


namespace sendbernar {
namespace server {
namespace handlers {

struct ComposeMessage: public SendBase {
    ComposeMessage(ConfigPtr configuration)
        : SendBase(configuration)
    { }

    virtual ~ComposeMessage() { }

    std::vector<std::string> paths() const override {
        return { composeMessageUrl() };
    }

    ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_post;
    }

    void doSendbernar(Context& ctx, const Account& account,
                      params::CommonParams utility, MetadataPtr metadata) const override;
};

}
}
}
