#pragma once

#include <mail/sendbernar/server/include/send_base.h>


namespace sendbernar::server::handlers {

struct GenerateOperationId: public SendBase {
    GenerateOperationId(ConfigPtr configuration)
        : SendBase(configuration)
    { }

    std::vector<std::string> paths() const override {
        return { generateOperationId() };
    }

    ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_post;
    }

    void doSendbernar(Context& ctx, const Account& account,
                      params::CommonParams common, MetadataPtr) const override;
};

}
