#pragma once

#include <mail/sendbernar/server/include/base.h>


namespace sendbernar::server::handlers {

struct Ping: public Base {
    Ping(ConfigPtr configuration)
        : Base(configuration)
    { }

    std::vector<std::string> paths() const override {
        return {"/ping"};
    }

    ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_get;
    }

    void execute(Context& ctx) const override {
        ctx.responseWith("pong");
    }
};

}
