#pragma once

#include <mail/sendbernar/server/include/send_base.h>


namespace sendbernar {
namespace server {
namespace handlers {

struct SaveTemplate: public SendBase {
    SaveTemplate(ConfigPtr configuration)
        : SendBase(configuration)
    { }

    virtual ~SaveTemplate() { }

    std::vector<std::string> paths() const override {
        return { saveTemplateUrl() };
    }

    ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_post;
    }

    void doSendbernar(Context& ctx, const Account& account,
                      params::CommonParams common, MetadataPtr metadata) const override;
};

}
}
}
