#pragma once

#include <mail/sendbernar/server/include/send_base.h>


namespace sendbernar::server::handlers {

struct SendBarbetMessage: public SendBase {
    SendBarbetMessage(ConfigPtr configuration)
        : SendBase(configuration)
    { }

    virtual ~SendBarbetMessage() { }

    std::vector<std::string> paths() const override {
        return { sendBarbetMessageUrl() };
    }

    ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_post;
    }

    void doSendbernar(Context& ctx, const Account& account,
                      params::CommonParams common, MetadataPtr metadata) const override;
};

}
