#pragma once

#include <mail/sendbernar/server/include/send_base.h>


namespace sendbernar {
namespace server {
namespace handlers {

struct SendDelayedMessage: public SendBase {
    std::vector<macs::Label::Symbol> symbolsToSet_;

    SendDelayedMessage(ConfigPtr configuration, const std::vector<macs::Label::Symbol>& symbolsToSet)
        : SendBase(configuration)
        , symbolsToSet_(symbolsToSet)
    { }

    ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_post;
    }

    virtual params::SendDelayed params(Context& ctx) const = 0;

    void doSendbernar(Context& ctx, const Account& account,
                      params::CommonParams common, MetadataPtr metadata) const override;
};

struct SendDelayed: public SendDelayedMessage {
    SendDelayed(ConfigPtr configuration)
        : SendDelayedMessage(configuration, { macs::Label::Symbol::seen_label,
                                              macs::Label::Symbol::delayedMessage_label })
    { }

    std::vector<std::string> paths() const override {
        return { sendDelayedUrl() };
    }

    params::SendDelayed params(Context& ctx) const override {
        return getSendDelayed(ctx, false);
    }
};

struct SendUndo: public SendDelayedMessage {
    SendUndo(ConfigPtr configuration)
        : SendDelayedMessage(configuration, { macs::Label::Symbol::seen_label,
                                              macs::Label::Symbol::undoMessage_label,
                                              macs::Label::Symbol::delayedMessage_label })
    { }

    std::vector<std::string> paths() const override {
        return { sendUndoUrl() };
    }

    params::SendDelayed params(Context& ctx) const override {
        return getSendDelayed(ctx, true);
    }
};

}
}
}
