#pragma once

#include <mail/sendbernar/server/include/send_base.h>


namespace sendbernar::server::handlers {

struct SendMessage: public SendBase {
    SendMessage(ConfigPtr configuration)
        : SendBase(std::move(configuration))
    { }

    virtual ~SendMessage() {}

    std::vector<std::string> paths() const override {
        return { sendMessageUrl() };
    }

    ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_post;
    }

    void doSendbernar(Context& ctx, const Account& account,
                      params::CommonParams common, MetadataPtr metadata) const override;
};

struct SendService: public SendMessage {
    using SendMessage::SendMessage;

    std::vector<std::string> paths() const override {
        return { sendServiceUrl() };
    }
};

}
