#pragma once

#include <mail/sendbernar/server/include/send_base.h>


namespace sendbernar::server::handlers {

struct SendShare: public SendBase {
    SendShare(ConfigPtr configuration)
        : SendBase(std::move(configuration))
    { }

    virtual ~SendShare() = default;

    std::vector<std::string> paths() const override {
        return { sendShareUrl() };
    }

    ymod_webserver::methods::http_method method() const override {
        return ymod_webserver::methods::mth_post;
    }

    void doSendbernar(Context& ctx, const Account& account,
                      params::CommonParams common, MetadataPtr metadata) const override;
};

}
