#pragma once

#include <mail/sendbernar/core/include/recipients_repository.h>
#include <mail/sendbernar/composer/include/system_mail_composer.h>
#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/core/include/account.h>
#include <macs_pg/service/service.h>
#include <macs/envelope.h>
#include <mail/sendbernar/server/include/context.h>


namespace sendbernar {
namespace server {

class RemindMessageSender {
    const params::CommonParams& common_;
    const RemindTemplates& templates_;
    const Context& ctx_;

    SendConfigurationPtr config_;
public:

    RemindMessageSender(const params::CommonParams& common, const RemindTemplates& templates,
        Context& ctx, SendConfigurationPtr config)
        : common_(common)
        , templates_(templates)
        , ctx_(ctx)
        , config_(config)
    { }

#define DECLARE_AND_SETTER(type, name) private: type name##_; \
                                       public: RemindMessageSender& name(const type& val) { name##_ = val; return *this; }

    DECLARE_AND_SETTER(std::string, messageId)
    DECLARE_AND_SETTER(std::string, date)
    DECLARE_AND_SETTER(std::string, to)
    DECLARE_AND_SETTER(std::string, inReplyTo)
    DECLARE_AND_SETTER(std::string, lang)

#undef DECLARE_AND_SETTER

    mail_errors::error_code composeAndSend(const macs::Label& label,
                                           const macs::Envelope& envelope);

    mail_errors::error_code composeAndSend(const std::string& uniqId);
};

}
}
