#pragma once

#include <mail/sendbernar/server/include/base.h>
#include <mail/sendbernar/services/include/blackbox.h>
#include <mail/sendbernar/core/include/metadata.h>
#include <ymod_tvm/module.h>


namespace sendbernar {
namespace server {

struct SendBase: public Base {
    SendBase(ConfigPtr configuration)
        : Base(configuration)
    { }

    SendConfigurationPtr sendConfig() const {
        return config_->send;
    }

    void execute(Context& ctx) const override;

    virtual void doSendbernar(Context& ctx, const Account& account,
                              params::CommonParams common, MetadataPtr metadata) const = 0;

    virtual void onMissingUid(Context& ctx, const BlackBoxException& e) const;
};

struct CallbackBase: public SendBase {
    using SendBase::SendBase;

    void onMissingUid(Context& ctx, const BlackBoxException& e) const override;
};

}
}
