#include <mail/sendbernar/server/include/fwd.h>
#include <ymod_webserver/server.h>
#include <ymod_webserver/response.h>
#include <ymod_httpclient/client.h>
#include <mail/ymod_cachedb/include/cache.h>
#include <mail/http_getter/client/include/module.h>
#include <mail/webmail/http_api_helpers/include/find_dependency.h>
#include <tvm_guard/module.h>
#include <yplatform/find.h>
#include <yplatform/module_registration.h>
#include <pa/async.h>
#include <stdexcept>


namespace sendbernar {


template<typename Handler>
void bindOne(ymod_webserver::server& server, const tvm_guard::Module& guard, std::shared_ptr<yplatform::reactor> reactor, ConfigPtr& config) {
    auto handler = server::createHandler<Handler>(config);
    guard.bind(server, "", handler->paths(), [handler, reactor] (ymod_webserver::response_ptr stream) {
        reactor->io()->post([handler, stream]() {
            handler->process(stream);
        });
    });
}


template<typename... Handler>
void bindImpl(ymod_webserver::server& server,
                  const tvm_guard::Module& guard,
                  const std::shared_ptr<yplatform::reactor>& reactorDefault,
                  ConfigPtr config) {
    (bindOne<Handler>(server, guard, reactorDefault, config), ...);
}

void bindHandlers(ymod_webserver::server& server,
                  const tvm_guard::Module& guard,
                  const std::shared_ptr<yplatform::reactor>& reactorAll,
                  const std::shared_ptr<yplatform::reactor>& reactorSendMessage,
                  const std::shared_ptr<yplatform::reactor>& reactorWriteAttachment,
                  ConfigPtr config) {

    using namespace ::sendbernar::server::handlers;

    bindImpl<
        Ping,
        Limits,
        SaveDraft,
        SaveTemplate,
        CancelSendDelayed,
        ComposeMessage,
        ComposeDraft,
        ListUnsubscribe,
        GenerateOperationId,
        server::callbacks::DelayedMessage,
        server::callbacks::NoAnswerRemindHandler,
        SendBarbetMessage
    >(server, guard, reactorAll, config);

    bindImpl<
        SendMessage,
        SendService,
        SendDelayed,
        SendShare,
        SendUndo
    >(server, guard, reactorSendMessage, config);

    bindImpl<
        WriteAttachment
    >(server, guard, reactorWriteAttachment, config);
}

struct Module: public yplatform::module {
    void init(const yplatform::ptree& cfg);
};

void Module::init(const yplatform::ptree& cfg) {
    using http_api::findDependency;

    pa::async_profiler::init(500000, 16, cfg.get<std::string>("profiler_log"));

    auto serverModule = findDependency<ymod_webserver::server>  (cfg, "dependencies.server");
    auto guardModule = findDependency<tvm_guard::Module>        (cfg, "dependencies.tvm_guard");

    ConfigPtr config = makeConfig(cfg,
        findDependency<ymod_cachedb::Cache>             (cfg, "dependencies.cachedb"),
        findDependency<http_getter::TypedClientModule>  (cfg, "dependencies.http_getter"),
        findDependency<ymod_maildb::Module>             (cfg, "dependencies.maildb")
    );

    const auto log = getModuleLogger();
    bindHandlers(*serverModule, *guardModule,
        findDependency<yplatform::reactor>(cfg, "dependencies.reactor"),
        findDependency<yplatform::reactor>(cfg, "dependencies.reactor_send_msg"),
        findDependency<yplatform::reactor>(cfg, "dependencies.reactor_write_attach"),
        config
    );

    LOGDOG_(log, notice, log::message="sendbernar::Module module initialized");
}

}

DEFINE_SERVICE_OBJECT(sendbernar::Module)
