#include <mail/sendbernar/server/include/send_base.h>
#include <mail/sendbernar/services/include/blackbox.h>
#include <mail/sendbernar/core/include/metadata.h>

#include <macs_pg/integration/pa_profiler.h>
#include <macs_pg/service/service.h>


namespace sendbernar::server {

void SendBase::onMissingUid(Context& ctx, const BlackBoxException& e) const {
    ctx.responseWith(make_error(ErrorResult::bbError, e.what()));
}

void CallbackBase::onMissingUid(Context& ctx, const BlackBoxException&) const {
    ctx.responseWith(CallbackResponseError{true});
}

void SendBase::execute(Context& ctx) const {
    try {
        const auto common = getCommonParams(ctx, ctx.request->context->remote_address);
        const Account account = BlackBox(sendConfig()->blackBox(),
                                         ctx.http, authDomain(common)).getAccount(common);

        MetadataPtr metadata = getMetadata(common, getUserJournalParams(ctx), ctx.logger, config_);

        doSendbernar(ctx, account, std::move(common), metadata);
    } catch (const ReaderException& e) {
        ctx.responseWith(make_error(ErrorResult::invalidParam, e.what()));
    } catch(const BlackBoxException& e) {
        onMissingUid(ctx, e);
    }
}

}
