#include <mail/sendbernar/services/include/captcha.h>
#include <boost/property_tree/xml_parser.hpp>


namespace sendbernar {

bool Captcha::check(const std::string& key, const std::string& response, const http_getter::TypedClient& http) const {
    HttpArguments args;
    args.add("key", key);
    args.add("rep", response);

    bool result = false;
    http.req(http.toGET(cfg.check).getArgs("args"_arg=args))->call(EndpointType::captcha_check, withDefaultHttpWrap([&] (yhttp::response resp) {
        boost::property_tree::ptree root;
        std::istringstream in(resp.body);

        boost::property_tree::read_xml(in, root);

        result = root.get<std::string>("image_check") == "ok";
    }));

    return result;
}

boost::optional<CaptchaResult> Captcha::request(const std::string& karma,
                                                          const boost::optional<std::string>& type,
                                                          const http_getter::TypedClient& http) const {
    static const std::string badCarmaValue = "85";

    HttpArguments args;
    args.add("checks", "1");

    if (type) {
        args.add("type", *type);
    } else {
        args.add("type", karma == badCarmaValue ? cfg.strongType : cfg.type);
    }

    boost::optional<CaptchaResult> result;
    http.req(http.toGET(cfg.generate).getArgs("args"_arg=args))->call(EndpointType::captcha_request, withDefaultHttpWrap([&] (yhttp::response resp) {
        boost::property_tree::ptree root;
        std::istringstream in(resp.body);

        boost::property_tree::read_xml(in, root);

        CaptchaResult ret;
        ret.url = root.get<std::string>("number.<xmlattr>.url");
        ret.key = root.get<std::string>("number");

        result = boost::make_optional(ret);
    }));

    return result;
}

CheckCaptchaResult checkCaptcha(const boost::optional<params::Captcha>& params, const SendConfiguration::Captcha& cfg,
                                const http_getter::TypedClient& http, const boost::optional<bool> captcha_passed) {
    if (captcha_passed.value_or(false)) {
        return CheckCaptchaResult::good;
    }
    if (params) {
        using namespace std::string_literals;

        Captcha captcha(cfg);

        const bool status = captcha.check(params->captcha_key, params->captcha_entered, http);
        return status ? CheckCaptchaResult::good : CheckCaptchaResult::bad;
    }
    return CheckCaptchaResult::doNotRequired;
}

}
