#pragma once

#include <mail/sendbernar/core/include/account.h>
#include <mail/sendbernar/core/include/http.h>
#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/client/include/params.h>
#include <mail_errors/error_code.h>
#include <variant>


namespace sendbernar {

struct BlackBoxException: public std::runtime_error {
    using std::runtime_error::runtime_error;
};

class BlackBox {
    SendConfiguration::BlackBox bb;
    const http_getter::TypedClient& http;
    std::string authDomain;

public:
    BlackBox(const SendConfiguration::BlackBox& bb,
             const http_getter::TypedClient& http, const std::string& authDomain)
        : bb(bb)
        , http(http)
        , authDomain(authDomain)
    { }

    static std::variant<std::string, Account> parse(const std::string& json);

    Account getAccount(const params::CommonParams& params) const;
};

}
