#pragma once

#include <mail/sendbernar/core/include/http.h>
#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/client/include/result.h>
#include <mail/sendbernar/core/include/check_captcha_result.h>


namespace sendbernar {

struct Captcha {
    const SendConfiguration::Captcha& cfg;

    Captcha(const SendConfiguration::Captcha& cfg)
        : cfg(cfg)
    { }

    bool check(const std::string& key, const std::string& response, const http_getter::TypedClient& http) const;
    boost::optional<CaptchaResult> request(const std::string& karma,
                                                     const boost::optional<std::string>& type,
                                                     const http_getter::TypedClient& http) const;
};

CheckCaptchaResult checkCaptcha(const boost::optional<params::Captcha>& params, const SendConfiguration::Captcha& cfg,
                                const http_getter::TypedClient& http, const boost::optional<bool> captcha_passed);

}
