#pragma once

#include <mail/sendbernar/client/include/params.h>
#include <mail/sendbernar/core/include/composed_message.h>
#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/services/include/source_mid.h>
#include <mail/sendbernar/core/include/account.h>

namespace sendbernar {

mail_errors::error_code createDelayedReminder(const params::CommonParams& common, const params::UserJournalParams& uj,
                                              const params::SendDelayed& delayed, params::ContinueSendingMessage params,
                                              const SourceMid& sourceMid, const http_getter::TypedClient& http, SendConfigurationPtr ptr,
                                              ContextLogger logger);

void deleteDelayedReminder(const std::string& uid, const SourceMid& sourceMid, const http_getter::TypedClient& http,
                           SendConfigurationPtr configuration);

mail_errors::error_code deleteDelayedReminderSync(const std::string& uid, const SourceMid& sourceMid, const http_getter::TypedClient& http,
                                                  SendConfigurationPtr configuration);

}
