#pragma once

#include <mail/sendbernar/core/include/remind_templates.h>
#include <boost/algorithm/string/replace.hpp>
#include <butil/xml/entities.h>

namespace sendbernar {

class RemindMsgFieldBuilder {
public:
    RemindMsgFieldBuilder(const RemindTemplate &remindTemplate)
        : remindTemplate(remindTemplate) {}

    std::string buildFromName() const {
        return remindTemplate.fromName;
    }
    std::string buildFromMailbox() const {
        return remindTemplate.fromMailbox;
    }

    std::string subject() const {
        return remindTemplate.subject;
    }

    std::string buildSubject(const std::string &subject) const {
        return boost::replace_all_copy(remindTemplate.subject, "<$subject>", subject);
    }

    std::string buildBody(const std::string &subject, const std::string &date,
            const std::string &mailto, const std::string &link, const std::string& from) const {
        std::string out = remindTemplate.body;
        boost::replace_all(out, "<$subject>", escapeHtmlSc(subject));
        boost::replace_all(out, "<$date>", date);
        boost::replace_all(out, "<$mailto>", escapeHtmlSc(mailto));
        boost::replace_all(out, "<$link>", escapeHtmlSc(link));
        boost::replace_all(out, "<$from>", escapeHtmlSc(from));
        return out;
    }

    std::string buildBody(const std::string& uniqId) const {
        std::string out = remindTemplate.body;
        boost::replace_all(out, "<$uniq_id>", uniqId);
        return out;
    }

private:
    RemindTemplate remindTemplate;

    std::string escapeHtmlSc(const std::string &input) const {
        std::string out = input;
        return encodeXmlEntities(out);
    }
};


}
