#include <mail/sendbernar/client/include/params.h>
#include <mail/ymod_cachedb/include/cache.h>

namespace sendbernar {

template<class Context, class YieldContext = io_result::sync_context>
bool checkAndResponseOperationId(const boost::optional<std::string>& operationId,
                                 const std::string& uid,
                                 const ymod_cachedb::Cache& cache,
                                 Context& context, YieldContext ctx = io_result::use_sync) {
    if (!operationId) {
        return false;
    }

    ymod_cachedb::OptValue val;
    try {
        val = cache.get(ymod_cachedb::Uid(std::stoll(uid)),
                        ymod_cachedb::Key(*operationId),
                        ymod_cachedb::RequestId(context.requestId()), ctx);
    } catch (const mail_errors::system_error& e) {
        LOGDOG_(context.logger, error, log::where_name="checkAndResponseOperationId", log::error_code=e.code());
        context.responseWith(make_error(ErrorResult::unexpectedCondition, e.what()));
        return true;
    } catch (const std::exception& e) {
        LOGDOG_(context.logger, error, log::where_name="checkAndResponseOperationId", log::exception=e);
        context.responseWith(make_error(ErrorResult::unexpectedCondition, e.what()));
        return true;
    }

    if (val) {
        context.responseWith(MessageSentCacheResponse{.messageId=std::move(*val)});
        return true;
    } else {
        return false;
    }
}

template<class Context, class YieldContext = io_result::sync_context>
void saveOperationId(const boost::optional<std::string>& operationId,
                     const std::string& uid, const std::string& value,
                     const ymod_cachedb::Cache& cache,
                     Context& context, YieldContext ctx = io_result::use_sync) {
    if (!operationId) {
        return;
    }

    try {
        cache.put(ymod_cachedb::Uid(std::stoll(uid)),
                  ymod_cachedb::Key(*operationId),
                  ymod_cachedb::Value(std::move(value)),
                  ymod_cachedb::RequestId(context.requestId()), ctx);
    } catch (const mail_errors::system_error& e) {
        LOGDOG_(context.logger, error, log::where_name="saveOperationId", log::error_code=e.code());
    } catch (const std::exception& e) {
        LOGDOG_(context.logger, error, log::where_name="saveOperationId", log::exception=e);
    }
}

}
