#pragma once

#include <mail/sendbernar/client/include/params.h>
#include <mail/sendbernar/core/include/config.h>
#include <mail/sendbernar/core/include/http.h>
#include <mail/sendbernar/core/include/account.h>
#include <mail/sendbernar/core/include/composed_message.h>
#include <mail/sendbernar/services/include/source_mid.h>

namespace sendbernar {

params::PostProcessMessage makePostprocessParams(const compose::SendDelayed& msg,
                                                 const macs::Lids& filteredLids, const boost::optional<macs::Mid>& sourceMid,
                                                 const params::SendMessage& params);
params::PostProcessMessage makePostprocessParams(const compose::SendMessage& msg,
                                                 const macs::Lids& filteredLids, const SourceMid& sourceMid,
                                                 const params::SendMessage& params);

struct PostProcessMessage {
    http_getter::TypedClientPtr http;
    params::CommonParams common;
    params::UserJournalParams uj;
    params::PostProcessMessage postprocess;
    ConfigPtr config;
    Account account;
    MetadataPtr metadata;
    ContextLogger logger;

    void logMessageSent();
    void setNoAnswerReminder();
    void markSpecialMids();
    void deleteDraft();

public:
    PostProcessMessage(http_getter::TypedClientPtr http, params::CommonParams common, params::UserJournalParams uj,
                       params::PostProcessMessage postprocess, ConfigPtr config,
                       Account account, MetadataPtr metadata, ContextLogger logger)
        : http(std::move(http))
        , common(std::move(common))
        , uj(std::move(uj))
        , postprocess(std::move(postprocess))
        , config(std::move(config))
        , account(std::move(account))
        , metadata(std::move(metadata))
        , logger(std::move(logger))
    { }

    void make();
    void make(boost::asio::yield_context yield);
};

}
