#pragma once

#include <mail/sendbernar/core/include/http.h>
#include <mail/sendbernar/core/include/configuration.h>
#include <mail/sendbernar/client/include/params_to_request.h>
#include <mail/callmeback/client/callmeback_client.h>


namespace sendbernar {

enum class RemindersType {
    delayed,
    undo,
    noAnswer
};

std::string toString(RemindersType type);

namespace log {
LOGDOG_DEFINE_ATTRIBUTE(RemindersType, reminder_type)
LOGDOG_DEFINE_ATTRIBUTE(std::string, reminder_date)
}

template <typename Out>
inline void to_tskv(Out& out, const char* key, RemindersType type) {
    out << ytskv::attr(key, toString(type));
}

}
