#pragma once

#include <mail/sendbernar/client/include/params.h>
#include <mail/sendbernar/core/include/metadata.h>
#include <mail/sendbernar/core/include/logger.h>


namespace sendbernar {

class SourceMid {
    boost::optional<macs::Mid> value_;
    bool isDelayed_ = false;
    bool isUndo_ = false;
    std::string messageId_;

    void init(const boost::optional<macs::Mid>& sourceMid, MetadataPtr meta, ContextLogger logger, bool savingTemplate);

public:
    SourceMid(const params::Message& message, MetadataPtr meta, ContextLogger logger, bool savingTemplate = false) {
        init(message.source_mid, meta, logger, savingTemplate);
    }

    SourceMid(const boost::optional<macs::Mid>& sourceMid, MetadataPtr meta, ContextLogger logger, bool savingTemplate = false) {
        init(sourceMid, meta, logger, savingTemplate);
    }

    bool isDelayed() const {
        return isDelayed_;
    }

    bool isDelayedOrUndo() const {
        return isUndo_ || isDelayed_;
    }

    bool isUndo() const {
        return isUndo_;
    }

    std::string messageId() const {
        return messageId_;
    }

    macs::Mid value() const {
        return value_.get_value_or("");
    }

    boost::optional<macs::Mid> optional() const {
        return value_;
    }
};

}
