#include <mail/sendbernar/services/include/make_responses.h>
#include <mail_getter/mime_type.h>


namespace sendbernar {

AttachmentResult transformAttach(const AliasClassList& mimeTypesList,
                                           const compose::Attachment& attach) {
    std::string type, subType;
    size_t slashPos = attach.contentType_.find('/');
    if (slashPos != std::string::npos) {
        type = attach.contentType_.substr(0, slashPos);
        subType = attach.contentType_.substr(slashPos + 1);
    } else {
        type = attach.contentType_;
    }

    std::string extension;
    size_t lastDotPos = attach.fileName_.rfind('.');
    if (lastDotPos != std::string::npos) {
        extension = attach.fileName_.substr(lastDotPos + 1);
    }

    return AttachmentResult{
        attach.hid_,
        attach.oldHid_,
        type,
        subType,
        attach.fileName_,
        mimeTypesList.getAlias(extension, MimeType(attach.contentType_)),
        attach.size_,
        attach.id_,
        attach.hash_,
    };
}

MessageSentResponse makeSentResponse(const compose::SendMessage& msg) {
    MessageSentResponse resp;

    resp.messageId = msg.messageId;
    resp.limited = msg.limited_;

    return resp;
}

MessageSavedResponse withLimited(const LimitedResult& limited, MessageSavedResponse&& resp) {
    resp.limited = limited;
    return resp;
}

template<class Message>
MessageSavedResponse makeSaveResponseImpl(const Message& msg, const macs::Fid& fid, const AliasClassList& types) {
    MessageSavedResponse resp;
    resp.messageId = msg.messageId;
    resp.stored.fid = fid;

    std::transform(msg.attachments.begin(),
                   msg.attachments.end(),
                   std::back_inserter(resp.attachments),
                   std::bind(&transformAttach, types, std::placeholders::_1));

    return resp;
}

MessageSavedResponse makeSaveResponse(const compose::SaveDraftOrTemplate& msg,
                                      const macs::Fid& fid, const AliasClassList& types) {
    return makeSaveResponseImpl(msg, fid, types);
}

MessageSavedResponse makeSaveResponse(const compose::SendDelayed& msg,
                                      const macs::Fid& fid, const AliasClassList& types) {
    return withLimited(msg.limited_, makeSaveResponseImpl(msg, fid, types));
}

MessageSavedResponse makeSaveResponse(const compose::SendMessage& msg,
                                      const macs::Fid& fid, const AliasClassList& types) {
    return withLimited(msg.limited_, makeSaveResponseImpl(msg, fid, types));
}

ComposeDraftResult makeComposeDraftResult(compose::ComposeDraft& msg, const AliasClassList& types) {
    ComposeDraftResult result;
    result.text = std::move(*msg.text);
    result.from = std::move(msg.envelopeFrom);

    std::transform(msg.attachments.begin(),
                   msg.attachments.end(),
                   std::back_inserter(result.attachments),
                   std::bind(&transformAttach, types, std::placeholders::_1));

    return result;
}

}
