#include <mail/sendbernar/services/include/source_mid.h>

namespace sendbernar {

void SourceMid::init(const boost::optional<macs::Mid>& sourceMid, MetadataPtr meta, ContextLogger logger, bool savingTemplate) {
    if (sourceMid) {
        try {
            const macs::Envelope env = meta->getById(*sourceMid);

            const macs::Label delayed = meta->labelBySymbol(macs::Label::Symbol::delayedMessage_label);
            const macs::Label undo = meta->labelBySymbol(macs::Label::Symbol::undoMessage_label);
            const macs::Label draft = meta->labelBySymbol(macs::Label::Symbol::draft_label);

            const macs::Fid draftFid = meta->fidBySymbol(macs::Folder::Symbol::drafts);
            const macs::Fid outboxFid = meta->fidBySymbol(macs::Folder::Symbol::outbox);
            const macs::Fid templateFid = meta->fidBySymbol(macs::Folder::Symbol::template_);

            const bool sourceMidCondition = env.hasLabel(delayed)
                    || env.hasLabel(undo)
                    || env.hasLabel(draft);

            bool inSpecialFid = env.fid() == draftFid || env.fid() == outboxFid;
            if (savingTemplate) {
                inSpecialFid = inSpecialFid || env.fid() == templateFid;
            }

            if (sourceMidCondition && inSpecialFid) {
                value_ = *sourceMid;
                isDelayed_ = env.hasLabel(delayed);
                isUndo_ = env.hasLabel(undo);
                messageId_ = env.rfcId();
            } else {
                LOGDOG_(logger, notice, log::where_name="SourceMid::init",
                        log::message="drop mid because of sendbernar condition",
                        log::fid=env.fid(), log::lids=env.labels());
            }
        } catch (const std::exception& e) {
            value_ = boost::none;
            isDelayed_ = false;
            isUndo_ = false;
            LOGDOG_(logger, error, log::where_name="SourceMid::init", log::exception=e);
        }
    }
}

}  // namespace sendbernar
