#!/usr/bin/env python3

import sys
import os
import yaml
from typing import NamedTuple


def _load_yaml(path: str):
    if len(path) <= 4:
        ext_path = path + ".yml"
    else:
        if path[-4:] != ".yml":
            ext_path = path + ".yml"
        else:
            ext_path = path
    with open(ext_path) as infile:
        res = yaml.safe_load(infile)
    return res


class Config(NamedTuple):
    qloud: dict
    registry: dict
    asg: dict
    jenkins: dict
    crt: dict
    storage: dict
    task_storage: dict
    list_max_items: int
    max_build_attempts: int


def load_config(path: str):
    raw = _load_yaml(path)
    with open(os.path.expanduser(raw["registry"]["token_path"])) as infile:
        raw["registry"]["headers"]["Authorization"] = raw["registry"]["headers"][
            "Authorization"
        ].format(infile.read().rstrip())
    with open(os.path.expanduser(raw["qloud"]["token_path"])) as infile:
        raw["qloud"]["headers"]["Authorization"] = raw["qloud"]["headers"]["Authorization"].format(
            infile.read().rstrip()
        )
    with open(os.path.expanduser(raw["jenkins"]["credentials"])) as infile:
        [user, token] = infile.read().rstrip().split(" ")
        raw["jenkins"]["user"] = user
        raw["jenkins"]["token"] = token
    with open(os.path.expanduser(raw["crt"]["token_path"])) as infile:
        raw["crt"]["headers"]["Authorization"] = raw["crt"]["headers"]["Authorization"].format(
            infile.read().rstrip()
        )
    return Config(
        qloud=raw["qloud"],
        registry=raw["registry"],
        asg=raw["asg"],
        jenkins=raw["jenkins"],
        crt=raw["crt"],
        storage=raw["storage"],
        task_storage=raw["storage"],
        list_max_items=raw["list_max_items"],
        max_build_attempts=raw["max_build_attempts"],
    )


def load_app_config(path: str):
    ret: dict = {}
    ret = _load_yaml(path)
    return ret
