import curses


class View:
    def __enter__(self):
        self.stdscr = curses.initscr()
        return self

    def __exit__(self, exc_type, exc_value, traceback):
        curses.endwin()

    def display_build_starting(self, num):
        self.stdscr.clear()
        self.stdscr.addstr(0, 0, "Next build number {}".format(num))
        self.stdscr.addstr(1, 0, "Start building...")
        self.stdscr.refresh()

    def display_build_info(self, prj, branch, info, log, done_percent):
        self.stdscr.clear()
        height, width = self.stdscr.getmaxyx()
        self.stdscr.addstr(0, 0, "Build {prj} on branch {branch}".format(prj=prj, branch=branch))
        self.stdscr.addstr(1, 0, "-" * width)
        n = height - 4
        i = 0
        for line in log[-n:]:
            if len(line) > 0:
                self.stdscr.addstr(2 + i, 0, line)
            i += 1
        progress_bar = self._get_progress_bar(done_percent, width - 2)
        self.stdscr.addstr(height - 2, 0, "[{}]".format(progress_bar))
        self.stdscr.refresh()

    def display_build_finished(self, info):
        self.stdscr.clear()
        self.stdscr.addstr(0, 0, "Build finished: {}".format(info["result"]))
        self.stdscr.refresh()

    def _get_progress_bar(self, done_percent, width):
        progress_bar = "#" * int(width * done_percent) + "." * int(width * (1 - done_percent))
        return progress_bar
