#!/usr/bin/env python3

import sys
import requests
import json


def stdout(*args):
    print(*args, file=sys.stdout)


def stderr(*args):
    print(*args, file=sys.stderr)


def query_yes_no(question, default="yes"):
    valid = {"yes": True, "y": True, "ye": True, "no": False, "n": False}
    if default is None:
        prompt = " [y/n] "
    elif default == "yes":
        prompt = " [Y/n] "
    elif default == "no":
        prompt = " [y/N] "
    else:
        raise ValueError('invalid default answer: "%s"' % default)

    while True:
        sys.stdout.write(question + prompt)
        choice = input().lower()
        if default is not None and choice == "":
            return valid[default]
        elif choice in valid:
            return valid[choice]
        else:
            stdout('please respond with "yes" or "no" ' '(or "y" or "n").')


def query_select(question, values):
    n = len(values)
    while True:
        stdout(question)
        for i in range(n):
            stdout("{}. {}".format(i + 1, values[i]))
        choice = input().lower()
        try:
            choice = int(choice)
        except Exception:
            choice = -1
        if choice >= 1 and choice <= n:
            return choice - 1
        else:
            stdout("please respond with integer between 1 and {}".format(n))


def http_get(url, headers):
    res = requests.get(url, headers=headers)
    res.raise_for_status()
    return res


def http_head(url, headers):
    res = requests.head(url, headers=headers)
    res.raise_for_status()
    return res


def http_post_json(url, headers, data):
    res = requests.post(url, headers=headers, json=data)
    res.raise_for_status()
    return res


def http_post_urlencoded(url, headers, data):
    res = requests.post(url, headers=headers, data=data)
    res.raise_for_status()
    return res


def http_put_json(url, headers, data):
    res = requests.put(url, headers=headers, json=data)
    res.raise_for_status()
    return res
