#!/usr/bin/env python3

from lib.aux import *


class Crt:
    def __init__(self, config: dict):
        self.config = config

    def get_certs(self):
        url = "{}?_fields=id,common_name,hosts".format(self.config["urls"]["certs"])
        results = []
        while url and url != "null":
            data = http_get(url, self.config["headers"]).json()
            results += data["results"]
            url = data["next"] if "next" in data else None
        return results

    def get_cert_by_id(self, id):
        url = "{}/{}/".format(self.config["urls"]["cert"], id)
        cert = http_get(url, self.config["headers"]).json()
        return cert

    def get_cert_by_host(self, host):
        url = "{}?host__exact={}&_fields=id,common_name,hosts,status".format(
            self.config["urls"]["certs"], host
        )
        certs = []
        while url and url != "null":
            data = http_get(url, self.config["headers"]).json()
            certs += data["results"]
            url = data["next"] if "next" in data else None
        id = None
        for cert in certs:
            if cert["status"] != "issued":
                continue
            if id is None or int(cert["id"]) > int(id):
                id = cert["id"]
        if id is None:
            raise Exception("cert for {} not found".format(host))
        return self.get_cert_by_id(id)

    def make_update_cert_request(self, cert):
        req = {}
        fields = ["type", "ca_name", "abc_service", "desired_ttl_days"]
        for field in fields:
            req[field] = cert[field]
        self._move_cn_to_first_place(cert)
        req["hosts"] = ",".join(cert["hosts"])
        return req

    def update_cert(self, cert):
        url = self.config["urls"]["cert"]
        req = self.make_update_cert_request(cert)
        res = http_post_json(url, self.config["headers"], req).json()
        return res

    def fetch_cert(self, cert):
        cert_data = http_get(cert["download2"], self.config["headers"]).text
        return cert_data

    def _move_cn_to_first_place(self, cert):
        cert["hosts"].remove(cert["common_name"])
        cert["hosts"].insert(0, cert["common_name"])
