#!/usr/bin/env python3

from lib.aux import *


class DockerRegistry:
    def __init__(self, config: dict, apps: dict):
        self.config = config
        self.apps = apps

    def get_sha256(self, app: str, version: str):
        """Return sha256 hash of the new Docker image by querying registry"""
        if app is None or version is None:
            raise Exception("deploy context not set, internal error, exiting")
        url = self.config["url"] + self.apps[app]["registry_path"] + "/manifests/" + version
        headers = http_head(url, self.config["headers"]).headers
        if "Docker-Content-Digest" not in headers:
            stderr("no manifest hash for version {0}, exiting".format(version))
            return None
        return headers["Docker-Content-Digest"]

    def registry_tag_list(self, app: str):
        """List image tags in Yandex.registry for app"""
        url = self.config["url"] + self.apps[app]["registry_path"] + "/tags/list"
        return http_get(url, self.config["headers"]).json()
