from contextlib import contextmanager
import os


@contextmanager
def temporary_chdir(path):
    prev_path = os.getcwd()
    os.chdir(path)
    try:
        yield
    finally:
        os.chdir(prev_path)
