from time import sleep


def retry(tries=3, delay=1):
    def retry_impl(fn):
        def wrapper(*args, **kwargs):
            i = 0
            while True:
                i += 1
                try:
                    return fn(*args, **kwargs)
                except:
                    if i < tries:
                        print("retry error...")
                        sleep(delay)
                    else:
                        raise

        return wrapper

    return retry_impl
