#!/usr/bin/env python3

from lib.aux import query_yes_no
from pathlib import PurePath


def configure_logbroker(logbroker, config, auto_confirm=False):
    for env in config["envs"]:
        tvm_id = config["tvm_id"][env]
        for log_config in config["logs"]:
            log_name = log_config["name"]
            topic = config.get_log_setting('topic', log_name, env)
            if not topic_exists(topic, logbroker):
                confirm_msg = 'Create topic "{}", grant write access to tvm_id={} and enable YT delivery'.format(
                    topic, tvm_id
                )
                if auto_confirm or query_yes_no(confirm_msg):
                    create_missing_directories(topic, logbroker)
                    logbroker.create_topic(topic)
                    logbroker.grant_write_access(topic, tvm_id)
                    logbroker.enable_yt_delivery(topic)


def topic_exists(topic, logbroker):
    path = PurePath("/" + topic)
    while path != PurePath("/"):
        if path.name not in logbroker.list(str(path.parent)):
            return False
        path = path.parent
    return True


def create_missing_directories(topic, logbroker):
    for path in reversed(PurePath("/" + topic).parents):
        if path == PurePath("/"):
            continue
        if path.name not in logbroker.list(str(path.parent)):
            logbroker.create_directory(str(path))
