#pragma once

#include <yplatform/module.h>

#include <internal/common/types.h>
#include <internal/common/context.h>
#include <internal/common/expected.h>

namespace settings::api {

class api : public yplatform::module {
public:
    virtual expected<MapOptions> getProfile(ContextPtr) = 0;
    virtual expected<MapOptions> getParams(ContextPtr) = 0;
    virtual expected<DoubleMapOptions> get(ContextPtr) = 0;
    virtual expected<void> updateProfile(ContextPtr) = 0;
    virtual expected<void> updateParams(ContextPtr) = 0;
    virtual expected<void> updateProtectedParams(ContextPtr) = 0;
    virtual expected<void> remove(ContextPtr) = 0;
    virtual expected<void> deleteParams(ContextPtr) = 0;
};

} // namespace settings::api
