#pragma once

#include <internal/api/api.h>
#include <internal/macs/interface.h>
#include <internal/user_journal/interface.h>
#include <internal/blackbox/account_info.h>
#include <internal/blackbox/interface.h>
#include <internal/recognizer/interface.h>

#include <yplatform/find.h>

namespace settings::api {

using MacsPtr = std::shared_ptr<macs::Interface>;
using BlackBoxPtr = std::shared_ptr<blackbox::Interface>;
using UserJournalPtr = std::shared_ptr<user_journal::Interface>;
using UTFizerPtr = std::shared_ptr<utfizer::Interface>;
using AccountInfoPtr = blackbox::AccountInfoPtr;

class api_impl : public api {
public:
    api_impl();
    api_impl(MacsPtr macs_, BlackBoxPtr blackbox_,
            UserJournalPtr userJournal_, UTFizerPtr utfizer_);

    void init(const yplatform::ptree& config);
    expected<MapOptions> getProfile(ContextPtr) override final;
    expected<MapOptions> getParams(ContextPtr) override final;
    expected<DoubleMapOptions> get(ContextPtr) override final;
    expected<void> updateProfile(ContextPtr) override final;
    expected<void> updateParams(ContextPtr) override final;
    expected<void> updateProtectedParams(ContextPtr) override final;
    expected<void> remove(ContextPtr) override final;
    expected<void> deleteParams(ContextPtr) override final;

    void utfizeSigns(MapOptions& options) const;

private:
    expected<bool> initSettings(ContextPtr ctx) const;
    expected<MapOptions> asyncGetProfile(ContextPtr ctx, AccountInfoPtr accountInfo,
        const SettingsList& settings) const;
    expected<DoubleMapOptions> asyncGet(ContextPtr ctx, AccountInfoPtr accountInfo,
        const SettingsList& settings) const;
    expected<void> asyncUpdateProfile(ContextPtr ctx, MapOptionsPtr options) const;

    MacsPtr macs;
    BlackBoxPtr blackbox;
    UserJournalPtr userJournal;
    UTFizerPtr utfizer;
    std::string mode = "production";
};

} // namespace settings::api
