#pragma once

#include <internal/common/types.h>

#include <internal/blackbox/account_info.h>

namespace settings::api {

using AccountInfoPtr = blackbox::AccountInfoPtr;

bool hasSetting(const SettingsList& settings, const std::string& name);

void addEmails(MapOptions& options, AccountInfoPtr accountInfo,
    const SettingsList& settings);

void addDefaultEmail(MapOptions& options, AccountInfoPtr accountInfo,
    const SettingsList& settings);

void addFromName(MapOptions& options, AccountInfoPtr accountInfo,
    const SettingsList& settings, std::string mode);

void getMacsSignatures(
    const SignaturesListOpt& signs,
    MacsSignaturesListOpt& macsSigns
);

} // namespace settings::api
