#pragma once

#include <internal/common/types.h>
#include <internal/blackbox/types.h>

namespace settings::blackbox {

struct EmailList {
    std::vector<Email> items;
    std::vector<Email>::const_iterator defaultEmail;
};

class AccountInfo {
public:
    AccountInfo(const std::string& firstName, const std::string& lastName,
        const std::string& firstNameEng, const std::string& lastNameEng, const AddressList& emailList);

    const EmailList& emails() const;
    const std::string& fromName() const;
    const std::string& fromNameEng() const;
    bool validateDefaultEmail(const std::string& email) const;
    bool validateReplyTo(const std::string& email) const;

private:
    std::string fromName_;
    std::string fromNameEng_;
    EmailList emails_;

    static std::string makeFromName(const std::string& firstName, const std::string& lastName);
};

using AccountInfoPtr = std::shared_ptr<AccountInfo>;

} // namespace blackbox::settings
